/* -- THIS FILE IS GENERATED - DO NOT EDIT *//* -*- Mode: C; c-basic-offset: 4 -*- */

#include <Python.h>



#line 3 "./spice-client-gtk.override"
#include <Python.h>
#include "pygobject.h"
#include "spice-common.h"
#include "spice-widget.h"
#include "spice-audio.h"
#line 14 "tmp.c"


/* ---------- types from other modules ---------- */
static PyTypeObject *_PyGObject_Type;
#define PyGObject_Type (*_PyGObject_Type)
static PyTypeObject *_PyGtkDrawingArea_Type;
#define PyGtkDrawingArea_Type (*_PyGtkDrawingArea_Type)
static PyTypeObject *_PyGtkWidget_Type;
#define PyGtkWidget_Type (*_PyGtkWidget_Type)


/* ---------- forward type declarations ---------- */
PyTypeObject G_GNUC_INTERNAL PySpiceAudio_Type;
PyTypeObject G_GNUC_INTERNAL PySpiceChannel_Type;
PyTypeObject G_GNUC_INTERNAL PySpiceCursorChannel_Type;
PyTypeObject G_GNUC_INTERNAL PySpiceDisplay_Type;
PyTypeObject G_GNUC_INTERNAL PySpiceDisplayChannel_Type;
PyTypeObject G_GNUC_INTERNAL PySpiceInputsChannel_Type;
PyTypeObject G_GNUC_INTERNAL PySpiceMainChannel_Type;
PyTypeObject G_GNUC_INTERNAL PySpicePlaybackChannel_Type;
PyTypeObject G_GNUC_INTERNAL PySpiceRecordChannel_Type;
PyTypeObject G_GNUC_INTERNAL PySpiceSession_Type;

#line 38 "tmp.c"



/* ----------- SpiceAudio ----------- */

#line 143 "./spice-client-gtk.override"
static int
_wrap_spice_audio_new(PyGObject *self,
                      PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = {"session", "context", "name", NULL};
    PyGObject *session = NULL;
    PyObject *py_context = NULL;
    char *name = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,
                                     "O!|Os:SpiceAudio", kwlist,
                                     &PySpiceSession_Type, &session,
                                     &py_context, &name))
	return -1;

    self->obj = (GObject *)spice_audio_new(SPICE_SESSION(session->obj), NULL, NULL);

    if (!self->obj) {
        PyErr_SetString(PyExc_RuntimeError, "could not create SpiceAudio object");
        return -1;
    }
    pygobject_register_wrapper((PyObject *)self);
    return 0;

}
#line 70 "tmp.c"


PyTypeObject G_GNUC_INTERNAL PySpiceAudio_Type = {
    PyObject_HEAD_INIT(NULL)
    0,                                 /* ob_size */
    "spice_client_gtk.Audio",                   /* tp_name */
    sizeof(PyGObject),          /* tp_basicsize */
    0,                                 /* tp_itemsize */
    /* methods */
    (destructor)0,        /* tp_dealloc */
    (printfunc)0,                      /* tp_print */
    (getattrfunc)0,       /* tp_getattr */
    (setattrfunc)0,       /* tp_setattr */
    (cmpfunc)0,           /* tp_compare */
    (reprfunc)0,             /* tp_repr */
    (PyNumberMethods*)0,     /* tp_as_number */
    (PySequenceMethods*)0, /* tp_as_sequence */
    (PyMappingMethods*)0,   /* tp_as_mapping */
    (hashfunc)0,             /* tp_hash */
    (ternaryfunc)0,          /* tp_call */
    (reprfunc)0,              /* tp_str */
    (getattrofunc)0,     /* tp_getattro */
    (setattrofunc)0,     /* tp_setattro */
    (PyBufferProcs*)0,  /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,                      /* tp_flags */
    NULL,                        /* Documentation string */
    (traverseproc)0,     /* tp_traverse */
    (inquiry)0,             /* tp_clear */
    (richcmpfunc)0,   /* tp_richcompare */
    offsetof(PyGObject, weakreflist),             /* tp_weaklistoffset */
    (getiterfunc)0,          /* tp_iter */
    (iternextfunc)0,     /* tp_iternext */
    (struct PyMethodDef*)NULL, /* tp_methods */
    (struct PyMemberDef*)0,              /* tp_members */
    (struct PyGetSetDef*)0,  /* tp_getset */
    NULL,                              /* tp_base */
    NULL,                              /* tp_dict */
    (descrgetfunc)0,    /* tp_descr_get */
    (descrsetfunc)0,    /* tp_descr_set */
    offsetof(PyGObject, inst_dict),                 /* tp_dictoffset */
    (initproc)_wrap_spice_audio_new,             /* tp_init */
    (allocfunc)0,           /* tp_alloc */
    (newfunc)0,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)0              /* tp_is_gc */
};



/* ----------- SpiceChannel ----------- */

static int
_wrap_spice_channel_new(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "s", "type", "id", NULL };
    PyGObject *s;
    int type, id;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O!ii:Spice.Channel.__init__", kwlist, &PySpiceSession_Type, &s, &type, &id))
        return -1;
    self->obj = (GObject *)spice_channel_new(SPICE_SESSION(s->obj), type, id);

    if (!self->obj) {
        PyErr_SetString(PyExc_RuntimeError, "could not create SpiceChannel object");
        return -1;
    }
    pygobject_register_wrapper((PyObject *)self);
    return 0;
}

static PyObject *
_wrap_spice_channel_destroy(PyGObject *self)
{
    
    spice_channel_destroy(SPICE_CHANNEL(self->obj));
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_spice_channel_connect(PyGObject *self)
{
    int ret;

    
    ret = spice_channel_connect(SPICE_CHANNEL(self->obj));
    
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_spice_channel_open_fd(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "fd", NULL };
    int fd, ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"i:Spice.Channel.open_fd", kwlist, &fd))
        return NULL;
    
    ret = spice_channel_open_fd(SPICE_CHANNEL(self->obj), fd);
    
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_spice_channel_disconnect(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "event", NULL };
    SpiceChannelEvent event;
    PyObject *py_event = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O:Spice.Channel.disconnect", kwlist, &py_event))
        return NULL;
    if (pyg_enum_get_value(SPICE_TYPE_CHANNEL_EVENT, py_event, (gpointer)&event))
        return NULL;
    
    spice_channel_disconnect(SPICE_CHANNEL(self->obj), event);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_spice_channel_test_capability(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "cap", NULL };
    int ret;
    unsigned long cap;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"k:Spice.Channel.test_capability", kwlist, &cap))
        return NULL;
    if (cap > G_MAXUINT32) {
        PyErr_SetString(PyExc_ValueError,
                        "Value out of range in conversion of"
                        " cap parameter to unsigned 32 bit integer");
        return NULL;
    }
    
    ret = spice_channel_test_capability(SPICE_CHANNEL(self->obj), cap);
    
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_spice_channel_set_capability(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "cap", NULL };
    unsigned long cap;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"k:Spice.Channel.set_capability", kwlist, &cap))
        return NULL;
    if (cap > G_MAXUINT32) {
        PyErr_SetString(PyExc_ValueError,
                        "Value out of range in conversion of"
                        " cap parameter to unsigned 32 bit integer");
        return NULL;
    }
    
    spice_channel_set_capability(SPICE_CHANNEL(self->obj), cap);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static const PyMethodDef _PySpiceChannel_methods[] = {
    { "destroy", (PyCFunction)_wrap_spice_channel_destroy, METH_NOARGS,
      NULL },
    { "connect", (PyCFunction)_wrap_spice_channel_connect, METH_NOARGS,
      NULL },
    { "open_fd", (PyCFunction)_wrap_spice_channel_open_fd, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "disconnect", (PyCFunction)_wrap_spice_channel_disconnect, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "test_capability", (PyCFunction)_wrap_spice_channel_test_capability, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "set_capability", (PyCFunction)_wrap_spice_channel_set_capability, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { NULL, NULL, 0, NULL }
};

PyTypeObject G_GNUC_INTERNAL PySpiceChannel_Type = {
    PyObject_HEAD_INIT(NULL)
    0,                                 /* ob_size */
    "spice_client_gtk.Channel",                   /* tp_name */
    sizeof(PyGObject),          /* tp_basicsize */
    0,                                 /* tp_itemsize */
    /* methods */
    (destructor)0,        /* tp_dealloc */
    (printfunc)0,                      /* tp_print */
    (getattrfunc)0,       /* tp_getattr */
    (setattrfunc)0,       /* tp_setattr */
    (cmpfunc)0,           /* tp_compare */
    (reprfunc)0,             /* tp_repr */
    (PyNumberMethods*)0,     /* tp_as_number */
    (PySequenceMethods*)0, /* tp_as_sequence */
    (PyMappingMethods*)0,   /* tp_as_mapping */
    (hashfunc)0,             /* tp_hash */
    (ternaryfunc)0,          /* tp_call */
    (reprfunc)0,              /* tp_str */
    (getattrofunc)0,     /* tp_getattro */
    (setattrofunc)0,     /* tp_setattro */
    (PyBufferProcs*)0,  /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,                      /* tp_flags */
    NULL,                        /* Documentation string */
    (traverseproc)0,     /* tp_traverse */
    (inquiry)0,             /* tp_clear */
    (richcmpfunc)0,   /* tp_richcompare */
    offsetof(PyGObject, weakreflist),             /* tp_weaklistoffset */
    (getiterfunc)0,          /* tp_iter */
    (iternextfunc)0,     /* tp_iternext */
    (struct PyMethodDef*)_PySpiceChannel_methods, /* tp_methods */
    (struct PyMemberDef*)0,              /* tp_members */
    (struct PyGetSetDef*)0,  /* tp_getset */
    NULL,                              /* tp_base */
    NULL,                              /* tp_dict */
    (descrgetfunc)0,    /* tp_descr_get */
    (descrsetfunc)0,    /* tp_descr_set */
    offsetof(PyGObject, inst_dict),                 /* tp_dictoffset */
    (initproc)_wrap_spice_channel_new,             /* tp_init */
    (allocfunc)0,           /* tp_alloc */
    (newfunc)0,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)0              /* tp_is_gc */
};



/* ----------- SpiceCursorChannel ----------- */

PyTypeObject G_GNUC_INTERNAL PySpiceCursorChannel_Type = {
    PyObject_HEAD_INIT(NULL)
    0,                                 /* ob_size */
    "spice_client_gtk.CursorChannel",                   /* tp_name */
    sizeof(PyGObject),          /* tp_basicsize */
    0,                                 /* tp_itemsize */
    /* methods */
    (destructor)0,        /* tp_dealloc */
    (printfunc)0,                      /* tp_print */
    (getattrfunc)0,       /* tp_getattr */
    (setattrfunc)0,       /* tp_setattr */
    (cmpfunc)0,           /* tp_compare */
    (reprfunc)0,             /* tp_repr */
    (PyNumberMethods*)0,     /* tp_as_number */
    (PySequenceMethods*)0, /* tp_as_sequence */
    (PyMappingMethods*)0,   /* tp_as_mapping */
    (hashfunc)0,             /* tp_hash */
    (ternaryfunc)0,          /* tp_call */
    (reprfunc)0,              /* tp_str */
    (getattrofunc)0,     /* tp_getattro */
    (setattrofunc)0,     /* tp_setattro */
    (PyBufferProcs*)0,  /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,                      /* tp_flags */
    NULL,                        /* Documentation string */
    (traverseproc)0,     /* tp_traverse */
    (inquiry)0,             /* tp_clear */
    (richcmpfunc)0,   /* tp_richcompare */
    offsetof(PyGObject, weakreflist),             /* tp_weaklistoffset */
    (getiterfunc)0,          /* tp_iter */
    (iternextfunc)0,     /* tp_iternext */
    (struct PyMethodDef*)NULL, /* tp_methods */
    (struct PyMemberDef*)0,              /* tp_members */
    (struct PyGetSetDef*)0,  /* tp_getset */
    NULL,                              /* tp_base */
    NULL,                              /* tp_dict */
    (descrgetfunc)0,    /* tp_descr_get */
    (descrsetfunc)0,    /* tp_descr_set */
    offsetof(PyGObject, inst_dict),                 /* tp_dictoffset */
    (initproc)0,             /* tp_init */
    (allocfunc)0,           /* tp_alloc */
    (newfunc)0,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)0              /* tp_is_gc */
};



/* ----------- SpiceDisplay ----------- */

static int
_wrap_spice_display_new(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "session", "id", NULL };
    PyGObject *session;
    int id;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O!i:Spice.Display.__init__", kwlist, &PySpiceSession_Type, &session, &id))
        return -1;
    self->obj = (GObject *)spice_display_new(SPICE_SESSION(session->obj), id);

    if (!self->obj) {
        PyErr_SetString(PyExc_RuntimeError, "could not create SpiceDisplay object");
        return -1;
    }
    pygobject_register_wrapper((PyObject *)self);
    return 0;
}

static PyObject *
_wrap_spice_display_mouse_ungrab(PyGObject *self)
{
    
    spice_display_mouse_ungrab(SPICE_DISPLAY(self->obj));
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_spice_display_copy_to_guest(PyGObject *self)
{
    
    spice_display_copy_to_guest(SPICE_DISPLAY(self->obj));
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_spice_display_paste_from_guest(PyGObject *self)
{
    
    spice_display_paste_from_guest(SPICE_DISPLAY(self->obj));
    
    Py_INCREF(Py_None);
    return Py_None;
}

#line 78 "./spice-client-gtk.override"
static PyObject*
_wrap_spice_display_set_grab_keys(PyGObject *self,
                            PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = {"keys", NULL};
    PyObject *keyList;
    int i;
    guint nkeysyms;
    guint *keysyms;
    SpiceGrabSequence *seq;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,
                                     "O|I:SpiceDisplay.set_grab_keys", kwlist,
                                     &keyList))
        return NULL;

    if (!PyList_Check(keyList))
        return NULL;

    nkeysyms = PyList_Size(keyList);
    keysyms = g_new0(guint, nkeysyms);

    for (i = 0 ; i < nkeysyms ; i++) {
        PyObject *val = PyList_GetItem(keyList, i);
        keysyms[i] = (guint)PyInt_AsLong(val);
    }

    seq = spice_grab_sequence_new(nkeysyms, keysyms);
    g_free(keysyms);

    spice_display_set_grab_keys(SPICE_DISPLAY(self->obj), seq);

    spice_grab_sequence_free(seq);

    Py_INCREF(Py_None);
    return Py_None;
}
#line 440 "tmp.c"


#line 60 "./spice-client-gtk.override"
static PyObject*
_wrap_spice_display_get_grab_keys(PyGObject *self,
                            PyObject *args, PyObject *kwargs)
{
    SpiceGrabSequence *seq;
    PyObject *keyList;
    int i;

    seq = spice_display_get_grab_keys(SPICE_DISPLAY(self->obj));

    keyList = PyList_New(0);
    for (i = 0 ; i < seq->nkeysyms ; i++)
       PyList_Append(keyList, PyInt_FromLong(seq->keysyms[i]));

    return keyList;
}
#line 460 "tmp.c"


#line 20 "./spice-client-gtk.override"
static PyObject*
_wrap_spice_display_send_keys(PyGObject *self,
                            PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = {"keys", "kind", NULL};
    PyObject *keyList;
    int kind = SPICE_DISPLAY_KEY_EVENT_CLICK;
    int i, len;
    guint *keys;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,
                                     "O|I:SpiceDisplay.send_keys", kwlist,
                                     &keyList, &kind))
	return NULL;

    if (!PyList_Check(keyList))
	return NULL;

    len = PyList_Size(keyList);
    keys = malloc(sizeof(guint)*len);
    for (i = 0 ; i < len ; i++) {
        PyObject *val;
        char *sym;
        val = PyList_GetItem(keyList, i);
        sym = PyString_AsString(val);
        if (!sym) {
            free(keys);
	    return NULL;
        }
        keys[i] = gdk_keyval_from_name(sym);
    }

    spice_display_send_keys(SPICE_DISPLAY(self->obj), keys, len, kind);
    free(keys);

    Py_INCREF(Py_None);
    return Py_None;
}
#line 502 "tmp.c"


static PyObject *
_wrap_spice_display_get_pixbuf(PyGObject *self)
{
    GdkPixbuf *ret;

    
    ret = spice_display_get_pixbuf(SPICE_DISPLAY(self->obj));
    
    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)ret);
}

static const PyMethodDef _PySpiceDisplay_methods[] = {
    { "mouse_ungrab", (PyCFunction)_wrap_spice_display_mouse_ungrab, METH_NOARGS,
      NULL },
    { "copy_to_guest", (PyCFunction)_wrap_spice_display_copy_to_guest, METH_NOARGS,
      NULL },
    { "paste_from_guest", (PyCFunction)_wrap_spice_display_paste_from_guest, METH_NOARGS,
      NULL },
    { "set_grab_keys", (PyCFunction)_wrap_spice_display_set_grab_keys, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "get_grab_keys", (PyCFunction)_wrap_spice_display_get_grab_keys, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "send_keys", (PyCFunction)_wrap_spice_display_send_keys, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "get_pixbuf", (PyCFunction)_wrap_spice_display_get_pixbuf, METH_NOARGS,
      NULL },
    { NULL, NULL, 0, NULL }
};

PyTypeObject G_GNUC_INTERNAL PySpiceDisplay_Type = {
    PyObject_HEAD_INIT(NULL)
    0,                                 /* ob_size */
    "spice_client_gtk.Display",                   /* tp_name */
    sizeof(PyGObject),          /* tp_basicsize */
    0,                                 /* tp_itemsize */
    /* methods */
    (destructor)0,        /* tp_dealloc */
    (printfunc)0,                      /* tp_print */
    (getattrfunc)0,       /* tp_getattr */
    (setattrfunc)0,       /* tp_setattr */
    (cmpfunc)0,           /* tp_compare */
    (reprfunc)0,             /* tp_repr */
    (PyNumberMethods*)0,     /* tp_as_number */
    (PySequenceMethods*)0, /* tp_as_sequence */
    (PyMappingMethods*)0,   /* tp_as_mapping */
    (hashfunc)0,             /* tp_hash */
    (ternaryfunc)0,          /* tp_call */
    (reprfunc)0,              /* tp_str */
    (getattrofunc)0,     /* tp_getattro */
    (setattrofunc)0,     /* tp_setattro */
    (PyBufferProcs*)0,  /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,                      /* tp_flags */
    NULL,                        /* Documentation string */
    (traverseproc)0,     /* tp_traverse */
    (inquiry)0,             /* tp_clear */
    (richcmpfunc)0,   /* tp_richcompare */
    offsetof(PyGObject, weakreflist),             /* tp_weaklistoffset */
    (getiterfunc)0,          /* tp_iter */
    (iternextfunc)0,     /* tp_iternext */
    (struct PyMethodDef*)_PySpiceDisplay_methods, /* tp_methods */
    (struct PyMemberDef*)0,              /* tp_members */
    (struct PyGetSetDef*)0,  /* tp_getset */
    NULL,                              /* tp_base */
    NULL,                              /* tp_dict */
    (descrgetfunc)0,    /* tp_descr_get */
    (descrsetfunc)0,    /* tp_descr_set */
    offsetof(PyGObject, inst_dict),                 /* tp_dictoffset */
    (initproc)_wrap_spice_display_new,             /* tp_init */
    (allocfunc)0,           /* tp_alloc */
    (newfunc)0,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)0              /* tp_is_gc */
};



/* ----------- SpiceDisplayChannel ----------- */

PyTypeObject G_GNUC_INTERNAL PySpiceDisplayChannel_Type = {
    PyObject_HEAD_INIT(NULL)
    0,                                 /* ob_size */
    "spice_client_gtk.DisplayChannel",                   /* tp_name */
    sizeof(PyGObject),          /* tp_basicsize */
    0,                                 /* tp_itemsize */
    /* methods */
    (destructor)0,        /* tp_dealloc */
    (printfunc)0,                      /* tp_print */
    (getattrfunc)0,       /* tp_getattr */
    (setattrfunc)0,       /* tp_setattr */
    (cmpfunc)0,           /* tp_compare */
    (reprfunc)0,             /* tp_repr */
    (PyNumberMethods*)0,     /* tp_as_number */
    (PySequenceMethods*)0, /* tp_as_sequence */
    (PyMappingMethods*)0,   /* tp_as_mapping */
    (hashfunc)0,             /* tp_hash */
    (ternaryfunc)0,          /* tp_call */
    (reprfunc)0,              /* tp_str */
    (getattrofunc)0,     /* tp_getattro */
    (setattrofunc)0,     /* tp_setattro */
    (PyBufferProcs*)0,  /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,                      /* tp_flags */
    NULL,                        /* Documentation string */
    (traverseproc)0,     /* tp_traverse */
    (inquiry)0,             /* tp_clear */
    (richcmpfunc)0,   /* tp_richcompare */
    offsetof(PyGObject, weakreflist),             /* tp_weaklistoffset */
    (getiterfunc)0,          /* tp_iter */
    (iternextfunc)0,     /* tp_iternext */
    (struct PyMethodDef*)NULL, /* tp_methods */
    (struct PyMemberDef*)0,              /* tp_members */
    (struct PyGetSetDef*)0,  /* tp_getset */
    NULL,                              /* tp_base */
    NULL,                              /* tp_dict */
    (descrgetfunc)0,    /* tp_descr_get */
    (descrsetfunc)0,    /* tp_descr_set */
    offsetof(PyGObject, inst_dict),                 /* tp_dictoffset */
    (initproc)0,             /* tp_init */
    (allocfunc)0,           /* tp_alloc */
    (newfunc)0,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)0              /* tp_is_gc */
};



/* ----------- SpiceInputsChannel ----------- */

static PyObject *
_wrap_spice_inputs_motion(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "dx", "dy", "button_state", NULL };
    int dx, dy, button_state;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"iii:Spice.InputsChannel.motion", kwlist, &dx, &dy, &button_state))
        return NULL;
    
    spice_inputs_motion(SPICE_INPUTS_CHANNEL(self->obj), dx, dy, button_state);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_spice_inputs_position(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "x", "y", "display", "button_state", NULL };
    int x, y, display, button_state;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"iiii:Spice.InputsChannel.position", kwlist, &x, &y, &display, &button_state))
        return NULL;
    
    spice_inputs_position(SPICE_INPUTS_CHANNEL(self->obj), x, y, display, button_state);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_spice_inputs_button_press(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "button", "button_state", NULL };
    int button, button_state;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"ii:Spice.InputsChannel.button_press", kwlist, &button, &button_state))
        return NULL;
    
    spice_inputs_button_press(SPICE_INPUTS_CHANNEL(self->obj), button, button_state);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_spice_inputs_button_release(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "button", "button_state", NULL };
    int button, button_state;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"ii:Spice.InputsChannel.button_release", kwlist, &button, &button_state))
        return NULL;
    
    spice_inputs_button_release(SPICE_INPUTS_CHANNEL(self->obj), button, button_state);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_spice_inputs_key_press(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "keyval", NULL };
    PyObject *py_keyval = NULL;
    guint keyval = 0;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O:Spice.InputsChannel.key_press", kwlist, &py_keyval))
        return NULL;
    if (py_keyval) {
        if (PyLong_Check(py_keyval))
            keyval = PyLong_AsUnsignedLong(py_keyval);
        else if (PyInt_Check(py_keyval))
            keyval = PyInt_AsLong(py_keyval);
        else
            PyErr_SetString(PyExc_TypeError, "Parameter 'keyval' must be an int or a long");
        if (PyErr_Occurred())
            return NULL;
    }
    
    spice_inputs_key_press(SPICE_INPUTS_CHANNEL(self->obj), keyval);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_spice_inputs_key_release(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "keyval", NULL };
    PyObject *py_keyval = NULL;
    guint keyval = 0;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O:Spice.InputsChannel.key_release", kwlist, &py_keyval))
        return NULL;
    if (py_keyval) {
        if (PyLong_Check(py_keyval))
            keyval = PyLong_AsUnsignedLong(py_keyval);
        else if (PyInt_Check(py_keyval))
            keyval = PyInt_AsLong(py_keyval);
        else
            PyErr_SetString(PyExc_TypeError, "Parameter 'keyval' must be an int or a long");
        if (PyErr_Occurred())
            return NULL;
    }
    
    spice_inputs_key_release(SPICE_INPUTS_CHANNEL(self->obj), keyval);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_spice_inputs_set_key_locks(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "locks", NULL };
    PyObject *py_locks = NULL;
    guint locks = 0;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O:Spice.InputsChannel.set_key_locks", kwlist, &py_locks))
        return NULL;
    if (py_locks) {
        if (PyLong_Check(py_locks))
            locks = PyLong_AsUnsignedLong(py_locks);
        else if (PyInt_Check(py_locks))
            locks = PyInt_AsLong(py_locks);
        else
            PyErr_SetString(PyExc_TypeError, "Parameter 'locks' must be an int or a long");
        if (PyErr_Occurred())
            return NULL;
    }
    
    spice_inputs_set_key_locks(SPICE_INPUTS_CHANNEL(self->obj), locks);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static const PyMethodDef _PySpiceInputsChannel_methods[] = {
    { "motion", (PyCFunction)_wrap_spice_inputs_motion, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "position", (PyCFunction)_wrap_spice_inputs_position, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "button_press", (PyCFunction)_wrap_spice_inputs_button_press, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "button_release", (PyCFunction)_wrap_spice_inputs_button_release, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "key_press", (PyCFunction)_wrap_spice_inputs_key_press, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "key_release", (PyCFunction)_wrap_spice_inputs_key_release, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "set_key_locks", (PyCFunction)_wrap_spice_inputs_set_key_locks, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { NULL, NULL, 0, NULL }
};

PyTypeObject G_GNUC_INTERNAL PySpiceInputsChannel_Type = {
    PyObject_HEAD_INIT(NULL)
    0,                                 /* ob_size */
    "spice_client_gtk.InputsChannel",                   /* tp_name */
    sizeof(PyGObject),          /* tp_basicsize */
    0,                                 /* tp_itemsize */
    /* methods */
    (destructor)0,        /* tp_dealloc */
    (printfunc)0,                      /* tp_print */
    (getattrfunc)0,       /* tp_getattr */
    (setattrfunc)0,       /* tp_setattr */
    (cmpfunc)0,           /* tp_compare */
    (reprfunc)0,             /* tp_repr */
    (PyNumberMethods*)0,     /* tp_as_number */
    (PySequenceMethods*)0, /* tp_as_sequence */
    (PyMappingMethods*)0,   /* tp_as_mapping */
    (hashfunc)0,             /* tp_hash */
    (ternaryfunc)0,          /* tp_call */
    (reprfunc)0,              /* tp_str */
    (getattrofunc)0,     /* tp_getattro */
    (setattrofunc)0,     /* tp_setattro */
    (PyBufferProcs*)0,  /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,                      /* tp_flags */
    NULL,                        /* Documentation string */
    (traverseproc)0,     /* tp_traverse */
    (inquiry)0,             /* tp_clear */
    (richcmpfunc)0,   /* tp_richcompare */
    offsetof(PyGObject, weakreflist),             /* tp_weaklistoffset */
    (getiterfunc)0,          /* tp_iter */
    (iternextfunc)0,     /* tp_iternext */
    (struct PyMethodDef*)_PySpiceInputsChannel_methods, /* tp_methods */
    (struct PyMemberDef*)0,              /* tp_members */
    (struct PyGetSetDef*)0,  /* tp_getset */
    NULL,                              /* tp_base */
    NULL,                              /* tp_dict */
    (descrgetfunc)0,    /* tp_descr_get */
    (descrsetfunc)0,    /* tp_descr_set */
    offsetof(PyGObject, inst_dict),                 /* tp_dictoffset */
    (initproc)0,             /* tp_init */
    (allocfunc)0,           /* tp_alloc */
    (newfunc)0,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)0              /* tp_is_gc */
};



/* ----------- SpiceMainChannel ----------- */

static PyObject *
_wrap_spice_main_set_display(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "id", "x", "y", "width", "height", NULL };
    int id, x, y, width, height;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"iiiii:Spice.MainChannel.set_display", kwlist, &id, &x, &y, &width, &height))
        return NULL;
    
    spice_main_set_display(SPICE_MAIN_CHANNEL(self->obj), id, x, y, width, height);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_spice_main_clipboard_release(PyGObject *self)
{
    
    spice_main_clipboard_release(SPICE_MAIN_CHANNEL(self->obj));
    
    Py_INCREF(Py_None);
    return Py_None;
}

static const PyMethodDef _PySpiceMainChannel_methods[] = {
    { "set_display", (PyCFunction)_wrap_spice_main_set_display, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "clipboard_release", (PyCFunction)_wrap_spice_main_clipboard_release, METH_NOARGS,
      NULL },
    { NULL, NULL, 0, NULL }
};

PyTypeObject G_GNUC_INTERNAL PySpiceMainChannel_Type = {
    PyObject_HEAD_INIT(NULL)
    0,                                 /* ob_size */
    "spice_client_gtk.MainChannel",                   /* tp_name */
    sizeof(PyGObject),          /* tp_basicsize */
    0,                                 /* tp_itemsize */
    /* methods */
    (destructor)0,        /* tp_dealloc */
    (printfunc)0,                      /* tp_print */
    (getattrfunc)0,       /* tp_getattr */
    (setattrfunc)0,       /* tp_setattr */
    (cmpfunc)0,           /* tp_compare */
    (reprfunc)0,             /* tp_repr */
    (PyNumberMethods*)0,     /* tp_as_number */
    (PySequenceMethods*)0, /* tp_as_sequence */
    (PyMappingMethods*)0,   /* tp_as_mapping */
    (hashfunc)0,             /* tp_hash */
    (ternaryfunc)0,          /* tp_call */
    (reprfunc)0,              /* tp_str */
    (getattrofunc)0,     /* tp_getattro */
    (setattrofunc)0,     /* tp_setattro */
    (PyBufferProcs*)0,  /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,                      /* tp_flags */
    NULL,                        /* Documentation string */
    (traverseproc)0,     /* tp_traverse */
    (inquiry)0,             /* tp_clear */
    (richcmpfunc)0,   /* tp_richcompare */
    offsetof(PyGObject, weakreflist),             /* tp_weaklistoffset */
    (getiterfunc)0,          /* tp_iter */
    (iternextfunc)0,     /* tp_iternext */
    (struct PyMethodDef*)_PySpiceMainChannel_methods, /* tp_methods */
    (struct PyMemberDef*)0,              /* tp_members */
    (struct PyGetSetDef*)0,  /* tp_getset */
    NULL,                              /* tp_base */
    NULL,                              /* tp_dict */
    (descrgetfunc)0,    /* tp_descr_get */
    (descrsetfunc)0,    /* tp_descr_set */
    offsetof(PyGObject, inst_dict),                 /* tp_dictoffset */
    (initproc)0,             /* tp_init */
    (allocfunc)0,           /* tp_alloc */
    (newfunc)0,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)0              /* tp_is_gc */
};



/* ----------- SpicePlaybackChannel ----------- */

static PyObject *
_wrap_spice_playback_channel_set_delay(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "delay_ms", NULL };
    unsigned long delay_ms;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"k:Spice.PlaybackChannel.set_delay", kwlist, &delay_ms))
        return NULL;
    if (delay_ms > G_MAXUINT32) {
        PyErr_SetString(PyExc_ValueError,
                        "Value out of range in conversion of"
                        " delay_ms parameter to unsigned 32 bit integer");
        return NULL;
    }
    
    spice_playback_channel_set_delay(SPICE_PLAYBACK_CHANNEL(self->obj), delay_ms);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static const PyMethodDef _PySpicePlaybackChannel_methods[] = {
    { "set_delay", (PyCFunction)_wrap_spice_playback_channel_set_delay, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { NULL, NULL, 0, NULL }
};

PyTypeObject G_GNUC_INTERNAL PySpicePlaybackChannel_Type = {
    PyObject_HEAD_INIT(NULL)
    0,                                 /* ob_size */
    "spice_client_gtk.PlaybackChannel",                   /* tp_name */
    sizeof(PyGObject),          /* tp_basicsize */
    0,                                 /* tp_itemsize */
    /* methods */
    (destructor)0,        /* tp_dealloc */
    (printfunc)0,                      /* tp_print */
    (getattrfunc)0,       /* tp_getattr */
    (setattrfunc)0,       /* tp_setattr */
    (cmpfunc)0,           /* tp_compare */
    (reprfunc)0,             /* tp_repr */
    (PyNumberMethods*)0,     /* tp_as_number */
    (PySequenceMethods*)0, /* tp_as_sequence */
    (PyMappingMethods*)0,   /* tp_as_mapping */
    (hashfunc)0,             /* tp_hash */
    (ternaryfunc)0,          /* tp_call */
    (reprfunc)0,              /* tp_str */
    (getattrofunc)0,     /* tp_getattro */
    (setattrofunc)0,     /* tp_setattro */
    (PyBufferProcs*)0,  /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,                      /* tp_flags */
    NULL,                        /* Documentation string */
    (traverseproc)0,     /* tp_traverse */
    (inquiry)0,             /* tp_clear */
    (richcmpfunc)0,   /* tp_richcompare */
    offsetof(PyGObject, weakreflist),             /* tp_weaklistoffset */
    (getiterfunc)0,          /* tp_iter */
    (iternextfunc)0,     /* tp_iternext */
    (struct PyMethodDef*)_PySpicePlaybackChannel_methods, /* tp_methods */
    (struct PyMemberDef*)0,              /* tp_members */
    (struct PyGetSetDef*)0,  /* tp_getset */
    NULL,                              /* tp_base */
    NULL,                              /* tp_dict */
    (descrgetfunc)0,    /* tp_descr_get */
    (descrsetfunc)0,    /* tp_descr_set */
    offsetof(PyGObject, inst_dict),                 /* tp_dictoffset */
    (initproc)0,             /* tp_init */
    (allocfunc)0,           /* tp_alloc */
    (newfunc)0,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)0              /* tp_is_gc */
};



/* ----------- SpiceRecordChannel ----------- */

PyTypeObject G_GNUC_INTERNAL PySpiceRecordChannel_Type = {
    PyObject_HEAD_INIT(NULL)
    0,                                 /* ob_size */
    "spice_client_gtk.RecordChannel",                   /* tp_name */
    sizeof(PyGObject),          /* tp_basicsize */
    0,                                 /* tp_itemsize */
    /* methods */
    (destructor)0,        /* tp_dealloc */
    (printfunc)0,                      /* tp_print */
    (getattrfunc)0,       /* tp_getattr */
    (setattrfunc)0,       /* tp_setattr */
    (cmpfunc)0,           /* tp_compare */
    (reprfunc)0,             /* tp_repr */
    (PyNumberMethods*)0,     /* tp_as_number */
    (PySequenceMethods*)0, /* tp_as_sequence */
    (PyMappingMethods*)0,   /* tp_as_mapping */
    (hashfunc)0,             /* tp_hash */
    (ternaryfunc)0,          /* tp_call */
    (reprfunc)0,              /* tp_str */
    (getattrofunc)0,     /* tp_getattro */
    (setattrofunc)0,     /* tp_setattro */
    (PyBufferProcs*)0,  /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,                      /* tp_flags */
    NULL,                        /* Documentation string */
    (traverseproc)0,     /* tp_traverse */
    (inquiry)0,             /* tp_clear */
    (richcmpfunc)0,   /* tp_richcompare */
    offsetof(PyGObject, weakreflist),             /* tp_weaklistoffset */
    (getiterfunc)0,          /* tp_iter */
    (iternextfunc)0,     /* tp_iternext */
    (struct PyMethodDef*)NULL, /* tp_methods */
    (struct PyMemberDef*)0,              /* tp_members */
    (struct PyGetSetDef*)0,  /* tp_getset */
    NULL,                              /* tp_base */
    NULL,                              /* tp_dict */
    (descrgetfunc)0,    /* tp_descr_get */
    (descrsetfunc)0,    /* tp_descr_set */
    offsetof(PyGObject, inst_dict),                 /* tp_dictoffset */
    (initproc)0,             /* tp_init */
    (allocfunc)0,           /* tp_alloc */
    (newfunc)0,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)0              /* tp_is_gc */
};



/* ----------- SpiceSession ----------- */

static int
_wrap_spice_session_new(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char* kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,
                                     ":spice_client_gtk.Session.__init__",
                                     kwlist))
        return -1;

    pygobject_constructv(self, 0, NULL);
    if (!self->obj) {
        PyErr_SetString(
            PyExc_RuntimeError, 
            "could not create spice_client_gtk.Session object");
        return -1;
    }
    return 0;
}

static PyObject *
_wrap_spice_session_connect(PyGObject *self)
{
    int ret;

    
    ret = spice_session_connect(SPICE_SESSION(self->obj));
    
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_spice_session_open_fd(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "fd", NULL };
    int fd, ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"i:Spice.Session.open_fd", kwlist, &fd))
        return NULL;
    
    ret = spice_session_open_fd(SPICE_SESSION(self->obj), fd);
    
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_spice_session_disconnect(PyGObject *self)
{
    
    spice_session_disconnect(SPICE_SESSION(self->obj));
    
    Py_INCREF(Py_None);
    return Py_None;
}

#line 117 "./spice-client-gtk.override"
static PyObject*
_wrap_spice_session_get_channels(PyGObject *self,
                                 PyObject *args, PyObject *kwargs)
{
    PyObject *py_list;
    GList *list, *tmp;
    PyObject *chann;

    list = spice_session_get_channels(SPICE_SESSION(self->obj));

    if ((py_list = PyList_New(0)) == NULL) {
        return NULL;
    }
    for (tmp = list; tmp != NULL; tmp = tmp->next) {
        chann = pygobject_new(G_OBJECT(tmp->data));
        if (chann == NULL) {
            Py_DECREF(py_list);
            return NULL;
        }
        PyList_Append(py_list, chann);
        Py_DECREF(chann);
    }
    return py_list;
}
#line 1127 "tmp.c"


static const PyMethodDef _PySpiceSession_methods[] = {
    { "connect", (PyCFunction)_wrap_spice_session_connect, METH_NOARGS,
      NULL },
    { "open_fd", (PyCFunction)_wrap_spice_session_open_fd, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "disconnect", (PyCFunction)_wrap_spice_session_disconnect, METH_NOARGS,
      NULL },
    { "get_channels", (PyCFunction)_wrap_spice_session_get_channels, METH_VARARGS,
      NULL },
    { NULL, NULL, 0, NULL }
};

PyTypeObject G_GNUC_INTERNAL PySpiceSession_Type = {
    PyObject_HEAD_INIT(NULL)
    0,                                 /* ob_size */
    "spice_client_gtk.Session",                   /* tp_name */
    sizeof(PyGObject),          /* tp_basicsize */
    0,                                 /* tp_itemsize */
    /* methods */
    (destructor)0,        /* tp_dealloc */
    (printfunc)0,                      /* tp_print */
    (getattrfunc)0,       /* tp_getattr */
    (setattrfunc)0,       /* tp_setattr */
    (cmpfunc)0,           /* tp_compare */
    (reprfunc)0,             /* tp_repr */
    (PyNumberMethods*)0,     /* tp_as_number */
    (PySequenceMethods*)0, /* tp_as_sequence */
    (PyMappingMethods*)0,   /* tp_as_mapping */
    (hashfunc)0,             /* tp_hash */
    (ternaryfunc)0,          /* tp_call */
    (reprfunc)0,              /* tp_str */
    (getattrofunc)0,     /* tp_getattro */
    (setattrofunc)0,     /* tp_setattro */
    (PyBufferProcs*)0,  /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,                      /* tp_flags */
    NULL,                        /* Documentation string */
    (traverseproc)0,     /* tp_traverse */
    (inquiry)0,             /* tp_clear */
    (richcmpfunc)0,   /* tp_richcompare */
    offsetof(PyGObject, weakreflist),             /* tp_weaklistoffset */
    (getiterfunc)0,          /* tp_iter */
    (iternextfunc)0,     /* tp_iternext */
    (struct PyMethodDef*)_PySpiceSession_methods, /* tp_methods */
    (struct PyMemberDef*)0,              /* tp_members */
    (struct PyGetSetDef*)0,  /* tp_getset */
    NULL,                              /* tp_base */
    NULL,                              /* tp_dict */
    (descrgetfunc)0,    /* tp_descr_get */
    (descrsetfunc)0,    /* tp_descr_set */
    offsetof(PyGObject, inst_dict),                 /* tp_dictoffset */
    (initproc)_wrap_spice_session_new,             /* tp_init */
    (allocfunc)0,           /* tp_alloc */
    (newfunc)0,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)0              /* tp_is_gc */
};



/* ----------- functions ----------- */

static PyObject *
_wrap_spice_util_set_debug(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "enabled", NULL };
    int enabled;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"i:spice_util_set_debug", kwlist, &enabled))
        return NULL;
    
    spice_util_set_debug(enabled);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_spice_util_get_debug(PyObject *self)
{
    int ret;

    
    ret = spice_util_get_debug();
    
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_spice_util_get_version_string(PyObject *self)
{
    const gchar *ret;

    
    ret = spice_util_get_version_string();
    
    if (ret)
        return PyString_FromString(ret);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_spice_main_clipboard_request(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "channel", "type", NULL };
    PyGObject *channel;
    unsigned long type;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O!k:spice_main_clipboard_request", kwlist, &PySpiceMainChannel_Type, &channel, &type))
        return NULL;
    if (type > G_MAXUINT32) {
        PyErr_SetString(PyExc_ValueError,
                        "Value out of range in conversion of"
                        " type parameter to unsigned 32 bit integer");
        return NULL;
    }
    
    spice_main_clipboard_request(SPICE_MAIN_CHANNEL(channel->obj), type);
    
    Py_INCREF(Py_None);
    return Py_None;
}

const PyMethodDef spice_functions[] = {
    { "spice_util_set_debug", (PyCFunction)_wrap_spice_util_set_debug, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "spice_util_get_debug", (PyCFunction)_wrap_spice_util_get_debug, METH_NOARGS,
      NULL },
    { "spice_util_get_version_string", (PyCFunction)_wrap_spice_util_get_version_string, METH_NOARGS,
      NULL },
    { "spice_main_clipboard_request", (PyCFunction)_wrap_spice_main_clipboard_request, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { NULL, NULL, 0, NULL }
};


/* ----------- enums and flags ----------- */

void
spice_add_constants(PyObject *module, const gchar *strip_prefix)
{
#ifdef VERSION
    PyModule_AddStringConstant(module, "__version__", VERSION);
#endif
  pyg_enum_add(module, "DisplayKeyEvent", strip_prefix, SPICE_TYPE_DISPLAY_KEY_EVENT);
  pyg_flags_add(module, "SessionVerify", strip_prefix, SPICE_TYPE_SESSION_VERIFY);
  pyg_enum_add(module, "SessionMigration", strip_prefix, SPICE_TYPE_SESSION_MIGRATION);
  pyg_enum_add(module, "ChannelEvent", strip_prefix, SPICE_TYPE_CHANNEL_EVENT);
  pyg_flags_add(module, "InputsLock", strip_prefix, SPICE_TYPE_INPUTS_LOCK);

  if (PyErr_Occurred())
    PyErr_Print();
}

/* initialise stuff extension classes */
void
spice_register_classes(PyObject *d)
{
    PyObject *module;

    if ((module = PyImport_ImportModule("gobject")) != NULL) {
        _PyGObject_Type = (PyTypeObject *)PyObject_GetAttrString(module, "GObject");
        if (_PyGObject_Type == NULL) {
            PyErr_SetString(PyExc_ImportError,
                "cannot import name GObject from gobject");
            return ;
        }
    } else {
        PyErr_SetString(PyExc_ImportError,
            "could not import gobject");
        return ;
    }
    if ((module = PyImport_ImportModule("gtk")) != NULL) {
        _PyGtkDrawingArea_Type = (PyTypeObject *)PyObject_GetAttrString(module, "DrawingArea");
        if (_PyGtkDrawingArea_Type == NULL) {
            PyErr_SetString(PyExc_ImportError,
                "cannot import name DrawingArea from gtk");
            return ;
        }
        _PyGtkWidget_Type = (PyTypeObject *)PyObject_GetAttrString(module, "Widget");
        if (_PyGtkWidget_Type == NULL) {
            PyErr_SetString(PyExc_ImportError,
                "cannot import name Widget from gtk");
            return ;
        }
    } else {
        PyErr_SetString(PyExc_ImportError,
            "could not import gtk");
        return ;
    }


#line 1323 "tmp.c"
    pygobject_register_class(d, "SpiceAudio", SPICE_TYPE_AUDIO, &PySpiceAudio_Type, Py_BuildValue("(O)", &PyGObject_Type));
    pygobject_register_class(d, "SpiceChannel", SPICE_TYPE_CHANNEL, &PySpiceChannel_Type, Py_BuildValue("(O)", &PyGObject_Type));
    pygobject_register_class(d, "SpiceCursorChannel", SPICE_TYPE_CURSOR_CHANNEL, &PySpiceCursorChannel_Type, Py_BuildValue("(O)", &PySpiceChannel_Type));
    pygobject_register_class(d, "SpiceDisplay", SPICE_TYPE_DISPLAY, &PySpiceDisplay_Type, Py_BuildValue("(O)", &PyGtkDrawingArea_Type));
    pygobject_register_class(d, "SpiceDisplayChannel", SPICE_TYPE_DISPLAY_CHANNEL, &PySpiceDisplayChannel_Type, Py_BuildValue("(O)", &PySpiceChannel_Type));
    pygobject_register_class(d, "SpiceInputsChannel", SPICE_TYPE_INPUTS_CHANNEL, &PySpiceInputsChannel_Type, Py_BuildValue("(O)", &PySpiceChannel_Type));
    pygobject_register_class(d, "SpiceMainChannel", SPICE_TYPE_MAIN_CHANNEL, &PySpiceMainChannel_Type, Py_BuildValue("(O)", &PySpiceChannel_Type));
    pygobject_register_class(d, "SpicePlaybackChannel", SPICE_TYPE_PLAYBACK_CHANNEL, &PySpicePlaybackChannel_Type, Py_BuildValue("(O)", &PySpiceChannel_Type));
    pygobject_register_class(d, "SpiceRecordChannel", SPICE_TYPE_RECORD_CHANNEL, &PySpiceRecordChannel_Type, Py_BuildValue("(O)", &PySpiceChannel_Type));
    pygobject_register_class(d, "SpiceSession", SPICE_TYPE_SESSION, &PySpiceSession_Type, Py_BuildValue("(O)", &PyGObject_Type));
    pyg_set_object_has_new_constructor(SPICE_TYPE_SESSION);
}
